package com.ejie.ab04b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TareaOS2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaOS2Dao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TareaOS2Dao {

	/**
	 * Inserts a single row in the TareaOS2 table.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOs2 the tarea os 2
	 * @return the tarea OS 2
	 */
	TareaOS2 add(TareaOS2 tareaOs2);

	/**
	 * Updates a single row in the TareaOS2 table.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOs2 the tarea os 2
	 * @return the tarea OS 2
	 */
	TareaOS2 update(TareaOS2 tareaOs2);

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 *  tarea
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tarea the tarea
	 * @return the tarea OS 2
	 */
	public TareaOS2 updateFilled(TareaOS2 tarea);

	/**
	 * Finds a single row in the TareaOS2 table.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  TareaOS2
	 *
	 * @param tareaOs2 the tarea os 2
	 * @return the tarea OS 2
	 */
	TareaOS2 find(TareaOS2 tareaOs2);

	/**
	 * Finds a single row in the TareaOS2 table.
	 * 
	 *  mailboxTaskId the mailbox task id
	 *  TareaOS2
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea OS 2
	 */
	@Transactional(readOnly = true)
	public TareaOS2 findByMailboxTaskId(String mailboxTaskId);

	/**
	 * Removes a single row in the TareaOS2 table.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *
	 * @param tareaOs2 the tarea os 2
	 */
	void remove(TareaOS2 tareaOs2);

	/**
	 * Finds a List of rows in the TareaOS2 table.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param tareaOs2 the tarea os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TareaOS2> findAll(TareaOS2 tareaOs2,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the TareaOS2 table using like.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param tareaOs2 the tarea os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TareaOS2> findAllLike(TareaOS2 tareaOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TareaOS2 table using like.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param tareaOs2 the tarea os 2
	 * @param startsWith the starts with
	 * @return the long
	 */
	Long findAllLikeCount(TareaOS2 tareaOs2, Boolean startsWith);

	/**
	 * Counts rows in the TareaOS2 table.
	 * 
	 *  tareaOs2
	 *            TareaOS2
	 *  Long
	 *
	 * @param tareaOs2 the tarea os 2
	 * @return the long
	 */
	Long findAllCount(TareaOS2 tareaOs2);

	/**
	 * Reorder selection.
	 * 
	 *  filterTareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS2>>
	 *
	 * @param filterTareaOS2 the filter tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaOS2>> reorderSelection(TareaOS2 filterTareaOS2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 *  filterTareaOS2
	 *            TareaOS2
	 *  searchTareaOS2
	 *            TareaOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS2>>
	 *
	 * @param filterTareaOS2 the filter tarea OS 2
	 * @param searchTareaOS2 the search tarea OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaOS2>> search(TareaOS2 filterTareaOS2,
			TareaOS2 searchTareaOS2, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

}
